/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.logic;

import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.transliterationlib.api.TRansliterationLib;
import dev.tr7zw.transliterationlib.api.event.RenderEvent;
import dev.tr7zw.transliterationlib.api.util.MathHelper;
import dev.tr7zw.transliterationlib.api.wrapper.entity.BoatEntity;
import dev.tr7zw.transliterationlib.api.wrapper.entity.HorseEntity;
import dev.tr7zw.transliterationlib.api.wrapper.entity.LivingEntity;
import dev.tr7zw.transliterationlib.api.wrapper.entity.Player;
import dev.tr7zw.transliterationlib.api.wrapper.item.Arm;
import dev.tr7zw.transliterationlib.api.wrapper.item.Hand;
import dev.tr7zw.transliterationlib.api.wrapper.item.Item;
import dev.tr7zw.transliterationlib.api.wrapper.item.ItemStack;
import dev.tr7zw.transliterationlib.api.wrapper.item.UseAction;
import dev.tr7zw.transliterationlib.api.wrapper.model.ModelPart;
import dev.tr7zw.transliterationlib.api.wrapper.model.PlayerEntityModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ArmTransformer {
    private Item filledMap = TRansliterationLib.transliteration.getEnumWrapper().getItems().getItem(TRansliterationLib.transliteration.constructors().newIdentifier("minecraft", "filled_map"));
    private Set<Item> holdingItems = new HashSet<Item>();
    private Map<Integer, float[]> lastRotations = new HashMap<Integer, float[]>();
    private Map<Integer, Long> lastUpdate = new HashMap<Integer, Long>();

    public void enable() {
        Item invalid = TRansliterationLib.transliteration.getEnumWrapper().getItems().getItem(TRansliterationLib.transliteration.constructors().newIdentifier("minecraft", "air"));
        for (String itemId : NEAnimationsLoader.config.holdingItems) {
            try {
                Item item = TRansliterationLib.transliteration.getEnumWrapper().getItems().getItem(TRansliterationLib.transliteration.constructors().newIdentifier(itemId.split(":")[0], itemId.split(":")[1]));
                if (invalid.getHandler() == item.getHandler()) continue;
                this.holdingItems.add(item);
            }
            catch (Exception ex) {
                System.err.println("Unknown item to add to the holding list: " + itemId);
            }
        }
        Arm arm = TRansliterationLib.transliteration.getEnumWrapper().getArm();
        Hand hand = TRansliterationLib.transliteration.getEnumWrapper().getHand();
        RenderEvent.SET_ANGLES_END.register((entity, model, tick, info) -> {
            if (TRansliterationLib.transliteration.getMinecraftClient().getWorld().isNull()) {
                return;
            }
            if (entity instanceof Player && ((Player)entity).isCrawling()) {
                return;
            }
            boolean rightHanded = entity.getMainArm() == arm.getRight();
            this.applyAnimations(entity, model, arm.getRight(), rightHanded ? hand.getMainHand() : hand.getOffHand(), tick);
            this.applyAnimations(entity, model, arm.getLeft(), !rightHanded ? hand.getMainHand() : hand.getOffHand(), tick);
            if (NEAnimationsLoader.config.enableAnimationSmoothing) {
                int id = entity.getId();
                float[] last = this.lastRotations.computeIfAbsent(id, i -> new float[6]);
                boolean differentFrame = true;
                long timePassed = System.currentTimeMillis() - this.lastUpdate.getOrDefault(id, 0L);
                if (timePassed < 1L) {
                    timePassed = 1L;
                }
                this.interpolate(model.getLeftArm(), last, 0, timePassed, differentFrame, NEAnimationsLoader.config.animationSmoothingSpeed);
                this.interpolate(model.getRightArm(), last, 3, timePassed, differentFrame, NEAnimationsLoader.config.animationSmoothingSpeed);
                this.lastUpdate.put(id, System.currentTimeMillis());
            }
        });
    }

    private void interpolate(ModelPart model, float[] last, int offset, long timePassed, boolean differentFrame, float speed) {
        if (!differentFrame) {
            model.setPitch(last[offset]);
            model.setYaw(last[offset + 1]);
            model.setRoll(last[offset + 2]);
            return;
        }
        if (timePassed > 200L) {
            last[offset] = model.getPitch();
            last[offset + 1] = model.getYaw();
            last[offset + 2] = model.getRoll();
            return;
        }
        float amount = 1.0f / (1000.0f / (float)timePassed) * speed;
        if (amount > 1.0f) {
            amount = 1.0f;
        }
        last[offset] = last[offset] + (model.getPitch() - last[offset]) * amount;
        last[offset + 1] = last[offset + 1] + (this.wrapDegrees(model.getYaw()) - this.wrapDegrees(last[offset + 1])) * amount;
        last[offset + 2] = last[offset + 2] + (model.getRoll() - last[offset + 2]) * amount;
        model.setPitch(last[offset]);
        model.setYaw(last[offset + 1]);
        model.setRoll(last[offset + 2]);
    }

    private void applyAnimations(LivingEntity livingEntity, PlayerEntityModel model, Arm arm, Hand hand, float tick) {
        UseAction action;
        ItemStack itemInHand = livingEntity.getStackInHand(hand);
        ItemStack itemInOtherHand = livingEntity.getStackInHand(hand == hand.getMainHand() ? hand.getOffHand() : hand.getMainHand());
        if (this.holdingItems.contains(itemInHand.getItem())) {
            this.applyArmTransforms(model, arm, -MathHelper.lerp((float)(-1.0f * (livingEntity.getPitch() - 90.0f) / 180.0f), (float)1.0f, (float)1.5f), -0.2f, 0.3f);
        }
        if (NEAnimationsLoader.config.enableInWorldMapRendering) {
            if (itemInHand.getItem().equals(this.filledMap) && itemInOtherHand.isEmpty() && hand == hand.getMainHand() || itemInOtherHand.getItem().equals(this.filledMap) && itemInHand.isEmpty() && hand == hand.getOffHand()) {
                this.applyArmTransforms(model, arm, -MathHelper.lerp((float)(-1.0f * (livingEntity.getPitch() - 90.0f) / 180.0f), (float)0.5f, (float)1.5f), -0.4f, 0.3f);
            } else if (itemInHand.getItem().equals(this.filledMap) && hand == hand.getMainHand()) {
                this.applyArmTransforms(model, arm, -MathHelper.lerp((float)(-1.0f * (livingEntity.getPitch() - 90.0f) / 180.0f), (float)0.5f, (float)1.5f), 0.0f, 0.3f);
            }
            if (itemInHand.getItem().equals(this.filledMap) && hand == hand.getOffHand()) {
                this.applyArmTransforms(model, arm, -MathHelper.lerp((float)(-1.0f * (livingEntity.getPitch() - 90.0f) / 180.0f), (float)0.5f, (float)1.5f), 0.0f, 0.3f);
            }
        }
        if (livingEntity.isSleeping()) {
            this.applyArmTransforms(model, arm, 0.0f, 0.0f, 0.0f);
            return;
        }
        if (livingEntity.getActiveHand() == hand && livingEntity.getItemUseTime() > 0 && ((action = itemInHand.getUseAction()) == action.getBlock() || action == action.getSpear() || action == action.getBow() || action == action.getCrossbow())) {
            return;
        }
        if (livingEntity.hasVehicle()) {
            if (livingEntity.getVehicle() instanceof BoatEntity && NEAnimationsLoader.config.enableRowBoatAnimation) {
                BoatEntity boat = (BoatEntity)livingEntity.getVehicle();
                float paddle = boat.interpolatePaddlePhase(arm == arm.getLeft() ? 0 : 1, tick);
                this.applyArmTransforms(model, arm, -1.1f - MathHelper.sin((float)paddle) * 0.3f, 0.2f, 0.3f);
            }
            if (livingEntity.getVehicle() instanceof HorseEntity && NEAnimationsLoader.config.enableHorseAnimation) {
                float rotation = -MathHelper.cos((float)(((HorseEntity)livingEntity.getVehicle()).getLimbAngle() * 0.3f));
                rotation = (float)((double)rotation * 0.1);
                this.applyArmTransforms(model, arm, -1.1f - rotation, -0.2f, 0.3f);
            }
        }
        if (livingEntity.isClimbing() && NEAnimationsLoader.config.enableLadderAnimation) {
            float rotation = -MathHelper.cos((float)((float)(livingEntity.getPos().getY() * 2.0)));
            rotation = (float)((double)rotation * 0.3);
            if (arm.equals(arm.getLeft())) {
                rotation *= -1.0f;
            }
            this.applyArmTransforms(model, arm, -1.1f - rotation, -0.2f, 0.3f);
        }
        if (livingEntity.getActiveHand() == hand && livingEntity.getItemUseTime() > 0 && NEAnimationsLoader.config.enableEatDrinkAnimation && ((action = itemInHand.getUseAction()).equals(action.getEat()) || action.equals(action.getDrink()))) {
            this.applyArmTransforms(model, arm, -MathHelper.lerp((float)(-1.0f * (livingEntity.getPitch() - 90.0f) / 180.0f), (float)1.0f, (float)2.0f) + MathHelper.sin((float)(tick * 1.5f)) * 0.1f, -0.3f, 0.3f);
        }
    }

    private void applyArmTransforms(PlayerEntityModel model, Arm arm, float pitch, float yaw, float roll) {
        ModelPart part = arm == arm.getRight() ? model.getRightArm() : model.getLeftArm();
        part.setPitch(pitch);
        part.setYaw(yaw);
        if (arm == arm.getLeft()) {
            part.setYaw(part.getYaw() * -1.0f);
        }
        part.setRoll(roll);
        if (arm == arm.getLeft()) {
            part.setRoll(part.getRoll() * -1.0f);
        }
    }

    private float wrapDegrees(float f) {
        float g = f % 6.283185f;
        if (g >= 3.1415925f) {
            g -= 6.283185f;
        }
        if (g < -3.1415925f) {
            g += 6.283185f;
        }
        return g;
    }
}

